/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.Card;
import jace.core.Computer;
import jace.core.PagedMemory;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class RAM {
    protected PagedMemory activeRead;
    protected PagedMemory activeWrite;
    private List<RAMListener> listeners = new Vector<RAMListener>();
    private List<RAMListener>[] listenerMap;
    private List<RAMListener>[] ioListenerMap;
    Card[] cards = new Card[8];
    int activeSlot = 0;

    public RAM() {
        this.refreshListenerMap();
    }

    public void setActiveCard(int slot) {
        if (this.activeSlot != slot) {
            this.activeSlot = slot;
            this.configureActiveMemory();
        }
    }

    public int getActiveSlot() {
        return this.activeSlot;
    }

    public Card[] getAllCards() {
        return this.cards;
    }

    public Card getCard(int slot) {
        if (slot >= 1 && slot <= 7) {
            return this.cards[slot];
        }
        return null;
    }

    public void addCard(Card c, int slot) {
        this.cards[slot] = c;
        c.setSlot(slot);
        c.registerListeners();
    }

    public void removeCard(Card c) {
        this.removeCard(c.getSlot());
    }

    public void removeCard(int slot) {
        if (this.cards[slot] != null) {
            this.cards[slot].removeListeners();
            this.cards[slot].disconnect();
        }
        this.cards[slot] = null;
    }

    public abstract void configureActiveMemory();

    public byte write(int address, byte b, boolean generateEvent) {
        byte[] page = this.activeWrite.getMemoryPage(address);
        byte old = 0;
        if (page == null) {
            if (generateEvent) {
                b = this.callListener(RAMEvent.TYPE.WRITE, address, old, b);
            }
        } else {
            int offset = address & 0xFF;
            old = page[offset];
            if (generateEvent) {
                b = this.callListener(RAMEvent.TYPE.WRITE, address, old, b);
            }
            page[offset] = b;
        }
        return old;
    }

    public void writeWord(int address, int w, boolean generateEvent) {
        byte lsb = this.write(address, (byte)(w & 0xFF), false);
        byte msb = this.write(address + 1, (byte)(w >> 8), false);
        int oldValue = msb << 8 + lsb;
        if (generateEvent) {
            this.callListener(RAMEvent.TYPE.WRITE, address, oldValue, w);
        }
    }

    public byte read(int address, boolean generateEvent) {
        byte value = this.activeRead.getMemoryPage(address)[address & 0xFF];
        if (generateEvent || (address & 0xFF00) == 49152) {
            value = this.callListener(RAMEvent.TYPE.READ, address, value, value);
        }
        return value;
    }

    public int readWord(int address, boolean generateEvent) {
        int lsb = 0xFF & this.read(address, false);
        int msb = (0xFF & this.read(address + 1, false)) << 8;
        int value = msb + lsb;
        if (generateEvent) {
            this.callListener(RAMEvent.TYPE.READ, address, value, value);
        }
        return value;
    }

    private void mapListener(RAMListener l, int address) {
        if ((address & 0xFF00) == 49152) {
            int index = address & 0xFF;
            List<RAMListener> listeners = this.ioListenerMap[index];
            if (listeners == null) {
                this.ioListenerMap[index] = listeners = new ArrayList<RAMListener>();
            }
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
        } else {
            int index = address >> 8;
            List<RAMListener> listeners = this.listenerMap[index];
            if (listeners == null) {
                this.listenerMap[index] = listeners = new ArrayList<RAMListener>();
            }
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
        }
    }

    private void addListenerRange(RAMListener l) {
        if (l.getScope() == RAMEvent.SCOPE.ADDRESS) {
            this.mapListener(l, l.getScopeStart());
        } else {
            int start = 0;
            int end = 65535;
            if (l.getScope() == RAMEvent.SCOPE.RANGE) {
                start = l.getScopeStart();
                end = l.getScopeEnd();
            }
            for (int i = start; i <= end; ++i) {
                this.mapListener(l, i);
            }
        }
    }

    private void refreshListenerMap() {
        this.listenerMap = new ArrayList[256];
        this.ioListenerMap = new ArrayList[256];
        for (RAMListener l : this.listeners) {
            this.addListenerRange(l);
        }
    }

    public void addListener(RAMListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
        this.addListenerRange(l);
    }

    public void removeListener(RAMListener l) {
        this.listeners.remove(l);
        this.refreshListenerMap();
    }

    public byte callListener(RAMEvent.TYPE t, int address, int oldValue, int newValue) {
        List<RAMListener> activeListeners = null;
        if ((address & 0xFF00) == 49152) {
            activeListeners = this.ioListenerMap[address & 0xFF];
            if (activeListeners == null && t.equals((Object)RAMEvent.TYPE.READ)) {
                return Computer.getComputer().getVideo().getFloatingBus();
            }
        } else {
            activeListeners = this.listenerMap[address >> 8 & 0xFF];
        }
        if (activeListeners != null) {
            RAMEvent e = new RAMEvent(t, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY, address, oldValue, newValue);
            for (RAMListener l : activeListeners) {
                l.handleEvent(e);
            }
            return (byte)e.getNewValue();
        }
        return (byte)newValue;
    }

    protected abstract void loadRom(String var1) throws IOException;

    public void dump() {
        for (int i = 0; i < 65535; i += 16) {
            System.out.print(Integer.toString(i, 16));
            System.out.print(":");
            String part1 = "";
            String part2 = "";
            for (int j = 0; j < 16; ++j) {
                int a = i + j;
                int br = 0xFF & this.activeRead.getMemory()[i >> 8][i & 0xFF];
                String s1 = Integer.toString(br, 16);
                System.out.print(' ');
                if (s1.length() == 1) {
                    System.out.print('0');
                }
                System.out.print(s1);
            }
            System.out.println();
        }
    }
}

